#include<gtest/gtest.h>
#include<gmock/gmock.h>

using ::testing::Return;

class Foo {
public:
    Foo() { x = 42; }
    virtual ~Foo() {};

    virtual int getValue() const { return x; }

private:
    int x;
};

class MockFoo : public Foo {
public:
    MOCK_CONST_METHOD0(getValue, int());
};

TEST(counttest, once) {
    MockFoo f;
    EXPECT_CALL(f, getValue()).Times(1).WillOnce(Return(42));

    EXPECT_EQ(f.getValue(), 42) << "Got wrong value";
}
